<?php
// ######################## SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// #################### PRE-CACHE TEMPLATES AND DATA ######################
$phrasegroups = array('style');
$specialtemplates = array('products');

// ########################## REQUIRE BACK-END ############################
require_once('./global.php');
require_once(DIR . '/includes/adminfunctions_template.php');

define('THIS_SCRIPT', 'radioandtv_admin');

// initialize
$categories = array();
$category_names = array();
rs_cache_categories();
$category_select = rs_make_category_select();
$stationids = array();
rs_cache_stationids();
$vbulletin->input->clean_array_gpc('r', array(
	'station'         => TYPE_UINT,
	'reportid'        => TYPE_UINT,
	'page'            => TYPE_UINT,
	'name'            => TYPE_STR,
	'description'     => TYPE_STR,
	'url'             => TYPE_STR,
	'website'         => TYPE_STR,
	'letter'          => TYPE_STR,
	'search'          => TYPE_STR,
	'category'        => TYPE_INT,
	'tocat'           => TYPE_INT,
	'fromcat'         => TYPE_INT,
	'rating'          => TYPE_INT,
	'deletestations'  => TYPE_BOOL,
));



// export category
if ( $_REQUEST['do'] == 'download' ) {
	
	$get_stationids = array();
	foreach ($stationids AS $stationid) {
		if ( !empty($_REQUEST['chk_'.$stationid]) ) {
			$get_stationids[] = $stationid;
		}
	}
	$get_stationids = implode(', ', $get_stationids);
	
	$where = "WHERE stationid IN ($get_stationids)";
	
	$stations = rs_get_stations($where);
	$xml = rs_make_xml($stations);
	rs_send_xml($xml);
}


// export category
if ( $_REQUEST['do'] == 'exportcategory' ) {
	
	$where = '';
	if (!empty($vbulletin->GPC['category'])) {
		$where = 'WHERE r.categoryid = ' . $vbulletin->GPC['category'];
	}
	
	$stations = rs_get_stations($where);
	$xml = rs_make_xml($stations);
	rs_send_xml($xml);
}



print_cp_header();


// impex options
if ( $_REQUEST['do'] == 'impex' ) {
	print_form_header(THIS_SCRIPT, 'import', 1, 1, 'importForm');
	print_table_header(' ');
	print_upload_row("XML ", 'xmlfile', 999999999);
	print_submit_row('', 0);
	
	print_form_header(THIS_SCRIPT, 'exportcategory', 0, 1, 'exportcategoryForm');
	print_table_header(' ');
	print_label_row('', $category_select);
	print_submit_row('', 0);
	
	print_form_header(THIS_SCRIPT, 'choose', 0, 1, 'chooseForm');
	print_table_header('   ');
	print_label_row('', $category_select);
	print_submit_row(' ', 0);
}

// choose stations
if ( $_REQUEST['do'] == 'choose' ) {
	$where = '';
	if (!empty($vbulletin->GPC['category'])) {
		$where = 'WHERE r.categoryid = ' . $vbulletin->GPC['category'];
	}
	$stations = rs_get_stations($where);
	
	print_form_header(THIS_SCRIPT, 'download', 0, 1, 'exportForm');
	print_table_header('  ');
	foreach ($stations AS $station) {
		$s = '<label for="id_chk_'.$station['stationid'].'"><input type="checkbox" id="id_chk_'.$station['stationid'].'" name="chk_'.$station['stationid'].'" /> ';
		$s .= ': ' . htmlentities($station['cat_name']) . ' - ' . htmlentities($station['name']) . '</label>';
		print_description_row($s);
	}
	print_submit_row('', 0);
}

// import stations
if ( $_REQUEST['do'] == 'import' ) {
	$vbulletin->input->clean_array_gpc('f', array(
		'xmlfile'        => TYPE_FILE,
	));
	
	if (file_exists($vbulletin->GPC['xmlfile']['tmp_name'])) {
		$xml = file_read($vbulletin->GPC['xmlfile']['tmp_name']);
	} else {
		print_cp_message("   XML .");
	}
	
	echo ' ...<br /><br />';
	
	// parse xml
	require_once(DIR . '/includes/class_xml.php');
	$xmlobj = new XMLparser($xml);
	if ($xmlobj->error_no == 1) {
		print_dots_stop();
		print_stop_message('no_xml_and_no_path');
	}
	else if ($xmlobj->error_no == 2) {
		print_dots_stop();
		print_stop_message('please_ensure_x_file_is_located_at_y', '', $vbulletin->GPC['path']);
	}
	if (empty($xmlobj->xmldata) OR $xmlobj->error_no > 0) {
		ctm_print_stop_back("boom. unknown xml error: ".$xmlobj->error_no);
	}
	if ( !$xml_array = $xmlobj->parse() ) {
		print_dots_stop();
		print_stop_message('xml_error_x_at_line_y', $xmlobj->error_string(), $xmlobj->error_line());
	}
	
	// process stations
	if (!empty($xml_array['station']['name'])) {// we have a single station
		rs_process_station($xml_array['station']);
	} else {
		foreach ( $xml_array['station'] AS $station ) {
			rs_process_station($station);
		}
	}
	
	echo '<br /><br /><center>!</center>';
}



print_cp_footer();



// #######################################################################
// ############################ FUNCTIONS ################################
// #######################################################################

function rs_cache_categories() {
	global $categories, $category_names, $db;
	$categories = array();
	$results = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "radiostation_category
								ORDER BY cat_name ASC");
	while( $cat = $db->fetch_array( $results ) ) {
		$categories[$cat['cat_name']] = $cat['categoryid'];
		$category_names[] = $cat['cat_name'];
	}
}

function rs_make_category_select() {
	global $categories;
	$select = '';
	$select .= '<option value=""> </option>';
	foreach ($categories AS $k => $v) {
		$select .= "\n" . '<option value="' . $v . '">' . $k . '</option>';
	}
	$select = '<select name="category" class="bginput">' . $select . '</select>';
	return $select;
}

function rs_make_xml($stations) {
	global $vbulletin;
	
	require_once(DIR . '/includes/class_xml.php');
	$xml = new vB_XML_Builder($vbulletin);
	
	// root
	$xml->add_group('stations');
	
	// add stations
	foreach ($stations AS $station) {
		$xml->add_group('station');
		$xml->add_tag('name', $station['name'], '', true);
		$xml->add_tag('category', $station['cat_name'], '', true);
		$xml->add_tag('description', $station['description'], '', true);
		$xml->add_tag('website', $station['website'], '', true);
		$xml->add_tag('url', $station['url'], '', true);
		$xml->add_tag('playerid', $station['playerid'], '', true);
		$xml->close_group();
	}
	
	// close root
	$xml->close_group();
	
	return $xml;
}

function rs_send_xml($xml) {
	$doc = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\r\n\r\n";
	$doc .= $xml->output();
	$xml = null;
	require_once(DIR . '/includes/functions_file.php');
	file_download($doc, 'radio-stations.xml', 'text/xml');
	exit;
}

function rs_get_stations($where) {
	global $db;
	$results = $db->query_read("
				SELECT * FROM " . TABLE_PREFIX . "radiostation AS r
				LEFT JOIN " . TABLE_PREFIX . "radiostation_category AS c ON (r.categoryid = c.categoryid)
				$where
				ORDER BY name ASC");
	$stations = array();
	while( $station = $db->fetch_array( $results ) ) {
		$stations[] = $station;
	}
	return $stations;
}

function rs_cache_stationids() {
	global $db, $stationids;
	$results = $db->query_read("SELECT stationid FROM " . TABLE_PREFIX . "radiostation");
	while( $cat = $db->fetch_array( $results ) ) {
		$stationids[] = $cat['stationid'];
	}
}

function rs_station_exists($url) {
	global $db;
	$results = $db->query_first("SELECT url FROM " . TABLE_PREFIX . "radiostation
									WHERE url = '" . $db->escape_string($url) . "'");
	if (!empty($results['url'])) {
		return true;
	}
	return false;
}

function rs_category_exists($name) {
	global $category_names;
	return in_array($name, $category_names);
}

function rs_add_category($name) {
	global $db;
	$db->query_write("INSERT INTO " . TABLE_PREFIX . "radiostation_category
				(cat_name) 
			VALUES ('" . $db->escape_string($name) . "')");
	rs_cache_categories();
}

function rs_add_station($station) {
	global $db, $vbulletin, $categories;
	
	// compatibility with version < 1.1
	$playerid = 0;
	if (!empty($station['playerid'])) {
		$playerid = $station['playerid'];
	}
	
	$db->query_write("INSERT INTO " . TABLE_PREFIX . "radiostation
				(name, url, addedby, dateadded, description, categoryid, website, playerid) 
			VALUES ('" . $db->escape_string($station['name']) . "',
					'" . $db->escape_string($station['url']) . "',
					" . $vbulletin->userinfo['userid'] . ",
					" . TIMENOW . ",
					'" . $db->escape_string($station['description']) . "',
					" . $categories[$station['category']] . ",
					'" . $db->escape_string($station['website']) . "',
					" . $playerid . ")");
}

function rs_process_station($station) {
	if (!rs_category_exists($station['category'])) {
		rs_add_category($station['category']);
		echo ' : ' . htmlentities($station['category']) . '<br />';
	}
	
	if (rs_station_exists($station['url'])) {
		echo '  : ' . htmlentities($station['name']) . '<br />';
	} else {
		rs_add_station($station);
		echo ': ' . htmlentities($station['name']) . '<br />';
	}
}
?>